IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Localidades_Ocupadas') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Localidades_Ocupadas
END
GO

CREATE PROCEDURE [dbo].[CPJ_Localidades_Ocupadas]		@pJson VARCHAR(8000)
AS 
SET NOCOUNT ON

/*
--CREADO: 18/3/2022   Fede y Gaby

--ACTUALIZADO: 25/03/2022 Fede, En proceso de Venta se agrega Fecha_Evento

--ACTUALIZADO: 25/03/2022 08:20 Fede, Se reemplaza TRY_CAST por CONVERT porque en SQL 2008 no existe. Se cambia CONVERT(DATETIME,dbo.CF_xParam('Loca_Fecha_Lim')) por CONVERT(DATE,dbo.CF_xParam('Loca_Fecha_Lim'))

--ACTUALIZADO: 29/03/2022 12:38 Fede, Para Entradas a Fechas Canjeadas se agrega el is_Estado_Cbte = 1 porque los pedidos ingresan con estado pendiente

--ACTUALIZADO: 04/04/2022 12:28 Fede, Para "VENTAS y REMITOS de Fechas(Partidos) CON PRECIO" y "VENTAS y REMITOS de Fechas(Partidos) SIN PRECIO (CANJES)" Se reemplaza AND PLP.Fecha_Evento >= GETDATE() + 1 por AND PLP.Fecha_Evento >= GETDATE(), ya que 24Hs antes del partido ya se liberaba todo

--ACTUALIZADO: 13/04/2022 13:24 Fede, Para "EN PROCESO DE VENTA" Se ele agrega el filtro de Id_Sector si llega por parametro

--ACTUALIZADO: 25/04/2022 10:22 Fede,
									1) Para todas las consultas se cambia Id_Estado_Cbte IN (2,4) por Id_Estado_Cbte IN (2,4,1) para agregar en Estado Pendiente.
									2) Para "VENTAS y REMITOS de Fechas(Partidos) CON PRECIO"
											"VENTAS y REMITOS de Fechas(Partidos) SIN PRECIO (CANJES)"
											"TICKETS IMPRESOS para fechas o partidos (no abonos) NO FIJOS UBICABLE"
											"PROTOCOLOS IMPRESOS para fechas o partidos (no abonos) NO FIJOS UBICABLE"
										se reemplaza AND PLP.Fecha_Evento >= GETDATE() por AND PLP.Evento_Hasta >= GETDATE()
										
--ACTUALIZADO: 06/05/2022 12:30 Fede,Flor y Adri Se agrega CONVERT en las CONVERT(DATE,PLP.Evento_Hasta) >= CONVERT(DATE,GETDATE()) Para que no validen las horas y se libere el dia siguiente.

--ACTUALIZADO: 17/05/2022 14:23 Fede, En Seccion "RESERVAS VENCIDAS" Se cambia la forma de busqueda del torneo con tabla temporal para que sea mas optimo el query

--ACTUALIZADO: 27/07/2022 Andrea, Gaston y Federico: Se eliminan los ISNULL(CL.Id_Cliente_Ref, 0) de los WHERE y se deja solo CL.Id_Cliente_Ref. Se cambia ISNULL(Evento_Cant_Dias_Limite, 0) por Evento_Cant_Dias_Limite
*/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
		,@pModoDebug			TINYINT
		,@pId_Lista_Precio		INT
		,@pId_Cliente			INT
		,@pId_Sector			INT
		,@pId_Producto			VARCHAR(14)
		,@pId_Trans				INT
		,@pInc_Abonos			TINYINT
		,@pInc_AbonosReserAnt	TINYINT
		,@pInc_AbonosReser		TINYINT
		,@pInc_TicketVend		TINYINT
		,@pInc_TicketCanj		TINYINT
		,@pInc_TicketImp		TINYINT
		,@pInc_ProtoFijos		TINYINT
		,@pInc_ProtoImp			TINYINT
		,@pInc_ProcesoVta		TINYINT
		,@pInc_Todos			TINYINT
		,@pInc_Libres			TINYINT
		,@pFormato				VARCHAR(10)



SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Lista_Precio		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Lista_Precio')), 0)
SET @pId_Cliente			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Sector				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Sector')), 0)
SET @pId_Producto			= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Producto')), '')
SET @pId_Trans				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')), 0)
SET @pInc_Abonos			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Inc_Abonos')), 0)
SET @pInc_AbonosReserAnt	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Inc_AbonosReserAnt')), 0)
SET @pInc_AbonosReser		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Inc_AbonosReser')), 0)
SET @pInc_TicketVend		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Inc_TicketVend')), 0)
SET @pInc_TicketCanj		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Inc_TicketCanj')), 0)
SET @pInc_TicketImp			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Inc_TicketImp')), 0)
SET @pInc_ProtoFijos		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Inc_ProtoFijos')), 0)
SET @pInc_ProtoImp			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Inc_ProtoImp')), 0)
SET @pInc_ProcesoVta		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Inc_ProcesoVta')), 0)
SET @pInc_Todos				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Inc_Todos')), 0)
SET @pInc_Libres			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Inc_Libres')), 0)
SET @pFormato				= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Formato')), '')


IF 	(@pInc_Abonos + @pInc_AbonosReserAnt + @pInc_AbonosReser	+ @pInc_TicketVend + @pInc_TicketCanj + @pInc_TicketImp	+ @pInc_ProtoFijos + @pInc_ProtoImp + @pInc_ProcesoVta = 0)
	AND @pInc_Todos = 0
BEGIN
	SET @pInc_Todos = 1
END

IF UPPER(@pFormato) IN ('TS','TT')        --TS Total x Sector     TT  Total por Tipo
BEGIN
	SET @pInc_Todos = 1
	SET @pInc_Libres = 1
END

IF  (@pInc_Libres = 1) 
BEGIN
	SET @pInc_Todos = 1
	SET @pId_Producto = ''
	SET @pId_Cliente = 0
	SET @pId_Trans = 0
	IF @pId_Lista_Precio = 0
		RAISERROR ('Id_Lista_Precio can not be zero.', 16,  1 ) 
END



IF @pInc_Todos = 1
BEGIN
	SET @pInc_Abonos		    = 1
	SET @pInc_AbonosReserAnt    = 1
	SET @pInc_AbonosReser	    = 1
	SET @pInc_TicketVend	    = 1
	SET @pInc_TicketCanj	    = 1
	SET @pInc_TicketImp		    = 1
	SET @pInc_ProtoFijos	    = 1
	SET @pInc_ProtoImp		    = 1
	SET @pInc_ProcesoVta		= 1
END 


/*FIN Variables recibidas por parametro a traves del JSON*/

/*====================================================================================================================================================*/

--IF(@pId_Lista_Precio = 0)  RAISERROR ('Id_Lista_Precio can not be zero.', 16,  1 ) 

/*====================================================================================================================================================*/

/*Variables Locales*/
DECLARE @SqlStr						NVARCHAR(MAX)
DECLARE @Id_Cliente_Ref				INT
DECLARE @Id_Evento_Grupo			INT
DECLARE @Evento_Desde				DATE
DECLARE @Evento_Hasta				DATE
DECLARE @Flag_Localidades			TINYINT
DECLARE @Fecha_Evento				DATETIME
DECLARE @Id_Evento_Grupo_Reservas	INT
DECLARE @Evento_Fecha_Reserva_Limite DATETIME
DECLARE @Tipo_Cbte_VW_Pedido		VARCHAR(4)
DECLARE @Tipo_Cbte_VW_Factura		VARCHAR(4)
DECLARE @cant_min_reserva			INT
DECLARE @version_SQL				VARCHAR(50)
/*FIN Variables Locales*/

BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Localidades_Ocupadas'
		PRINT 'Parametros: '+ @pJson  
	END

	/*====================================================================================================================================================*/

	SET @version_SQL = dbo.CF_DB_Version()

	/*====================================================================================================================================================*/

	IF(@pId_Cliente > 0)
	BEGIN
		SELECT 		
		@Id_Cliente_Ref = ISNULL(Id_Cliente_Ref, 0)
		FROM Clientes 
		WHERE
		Id_Cliente = @pId_Cliente

		IF(@Id_Cliente_Ref = 0)
		BEGIN
			SET @Id_Cliente_Ref = @pId_Cliente
		END
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@pId_Cliente: ' + CONVERT(VARCHAR(10), @pId_Cliente) + '. @Id_Cliente_Ref: '+ CONVERT(VARCHAR(10), @Id_Cliente_Ref)  
	END

	/*====================================================================================================================================================*/

	IF OBJECT_ID('tempdb..#Rta_CPJ_Localidades_Ocupadas') IS NOT NULL
	BEGIN
		DROP TABLE #Rta_CPJ_Localidades_Ocupadas
	END

	CREATE TABLE #Rta_CPJ_Localidades_Ocupadas	(Id_Trans				INT
												, Id_Cliente			INT
												, Id_Lista				INT
												, Razon_Social			VARCHAR(100)
												, Fecha_QA				DATETIME
												, Fecha_Venc			DATETIME
												, Fecha_Desde			DATETIME
												, Fecha_Hasta			DATETIME
												, Descripcion			VARCHAR(100)
												, Id_Producto			VARCHAR(14)
												, Descripcion_Resumida	VARCHAR(100)
												, Estado				VARCHAR(10)
												, Serie					VARCHAR(100)
												, Item					INT
												, Flag_QA				CHAR(1)
												, Fecha_Cbte			DATETIME
												, Cbte_Descrip			VARCHAR(50)
												, Id_Estado_Cbte		SMALLINT
												, Cantidad				INT
												, Lote					VARCHAR(20)
												, Id_Sector				SMALLINT
												, Sector_Codigo			VARCHAR(10)
												, Sector_Nombre			VARCHAR(50)
												, Columna				VARCHAR(5)
												, Fila					VARCHAR(5)
												, Fecha_Evento			DATETIME
												)

	CREATE INDEX #IX_Rta_CPJ_Loc_Ocup_Prod ON #Rta_CPJ_Localidades_Ocupadas (Id_Producto)

	CREATE INDEX #IX_Rta_CPJ_Loc_Ocup_ColFil ON #Rta_CPJ_Localidades_Ocupadas (Sector_Codigo,Id_Sector,Columna,Fila)

	/*====================================================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@pId_Lista_Precio: '+ CONVERT(VARCHAR(10), @pId_Lista_Precio)  
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Actualiza Evento_Cant_Dias_Limite y Evento_Fecha_Reserva_Limite en caso de ser Abonos y no tenerlo configurado.'
	END

	IF(@pId_Lista_Precio > 0)
	BEGIN
		UPDATE Prod_Listas_Precios 
		SET 
		Evento_Cant_Dias_Limite = CONVERT(INT, dbo.CF_xParam('Loca_Fecha_Lim_Dias'))
		WHERE 
		Id_Lista_Precio = @pId_Lista_Precio  
		AND Evento_Cant_Dias_Limite = 0
		AND Flag_Localidades = 1

		UPDATE Prod_Listas_Precios 
		SET 
		Evento_Fecha_Reserva_Limite = CONVERT(DATE,dbo.CF_xParam('Loca_Fecha_Lim'))
		WHERE 
		Id_Lista_Precio = @pId_Lista_Precio 
		AND Evento_Fecha_Reserva_Limite IS NULL
		AND Flag_Localidades = 1

		SELECT	
		@Id_Evento_Grupo = ISNULL(Id_Evento_Grupo, 0), 
		@Evento_Desde = Evento_Desde , 
		@Evento_Hasta = Evento_Hasta , 
		@Flag_Localidades = Flag_Localidades,
		@Fecha_Evento = Fecha_Evento,
		@Evento_Fecha_Reserva_Limite = Evento_Fecha_Reserva_Limite		
		FROM Prod_Listas_Precios 
		WHERE 
		Id_Lista_Precio = @pId_Lista_Precio	

	   SELECT	
	   @Id_Evento_Grupo_Reservas = Id_Evento_Grupo_Reservas
	   FROM Eventos_Grupos 
	   WHERE 
	   Id_Evento_Grupo = @Id_Evento_Grupo 
	   AND @Id_Evento_Grupo > 0 

		/* Si es partido, tomo la fecha del partido*/
		IF @Flag_Localidades = 2
		BEGIN
			  SET @Evento_Desde = @Fecha_Evento 
			  SET @Evento_Hasta = @Fecha_Evento  
		END

		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@Id_Evento_Grupo: '+ CONVERT(VARCHAR(10), @Id_Evento_Grupo)  
			PRINT '@Evento_Desde: '+ CONVERT(VARCHAR(10), @Evento_Desde, 112)  
			PRINT '@Evento_Hasta: '+ CONVERT(VARCHAR(10), @Evento_Hasta, 112)  
			PRINT '@Flag_Localidades: '+ CONVERT(VARCHAR(10), @Flag_Localidades)  
			PRINT '@Fecha_Evento: '+ CONVERT(VARCHAR(20), @Fecha_Evento, 112)  
			PRINT '@Evento_Fecha_Reserva_Limite: '+ CONVERT(VARCHAR(10), @Evento_Fecha_Reserva_Limite, 112)  
			PRINT '@Id_Evento_Grupo_Reservas: '+ CONVERT(VARCHAR(10), @Id_Evento_Grupo_Reservas)  
		END
	END
	ELSE
	BEGIN
		SET @Evento_Desde = GETDATE() 
		SET @Evento_Hasta = GETDATE()
		
		--25/03/2022 Se reemplaza TRY_CAST porque en SQL 2008 R2 no existe
		--SET @Evento_Fecha_Reserva_Limite = TRY_CAST(dbo.CF_xParam('Loca_Fecha_Lim') AS DATE)
		SET @Evento_Fecha_Reserva_Limite = CONVERT(DATE, dbo.CF_xParam('Loca_Fecha_Lim'))		
	END

/*======================================================================= RESERVAS ANTICIPADAS=============================================================================*/
IF @pInc_AbonosReserAnt = 1
BEGIN
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'RESERVAS ANTICIPADAS'
	END

	IF CONVERT(DATE,@Evento_Fecha_Reserva_Limite) >= CONVERT(DATE,GETDATE()) 
	BEGIN

		SET @SqlStr =	''

		SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Localidades_Ocupadas '
		SET @SqlStr +=	' SELECT'
		SET @SqlStr +=	' DISTINCT'
		SET @SqlStr +=	' CB.Id_Trans,'
		SET @SqlStr +=	' ISNULL(CI.Id_Cliente, 0) AS Id_Cliente,'
		SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0) AS Id_Lista,'
		SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '''')))) AS Razon_Social,'
		SET @SqlStr +=	' CI.Fecha_QA,'
		SET @SqlStr +=	' CI.Fecha_Venc,'
		SET @SqlStr +=	' PLP.Fecha_Desde,'
		SET @SqlStr +=	' PLP.Fecha_Hasta,'
		SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(PLP.Descripcion, '''')))) AS Descripcion,'
		SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CI.Id_Producto, '''')))) AS Id_Producto,'
		SET @SqlStr +=	' UPPER(RTRIM(LTRIM(ISNULL(PR.Descripcion_Resumida, '''')))) AS Descripcion_Resumida,'
		SET @SqlStr +=	' ''ARA'' AS Estado,'
					/*
						A	-> Abono Comprado    
						ARA -> Abono Reserva Anticipada    
						AR	-> Abono Resevado     
						TV	-> Ticket Vendido
						TC	-> Ticket Canjeado
						TI	-> Ticket Impreso
						PI	-> Protocolos Impresos
						PU	-> Protocolo Fijo
						PV	-> En Proceso de Venta
					*/
		SET @SqlStr +=	' CI.Serie,'
		SET @SqlStr +=	' CI.Item,'
		SET @SqlStr +=	' CI.Flag_QA,'
		SET @SqlStr +=	' CB.Fecha,'
		SET @SqlStr +=	' dbo.CF_Cbte_Descrip(CB.Id_Trans) AS Cbte_Descrip,'
		SET @SqlStr +=	' CB.Id_Estado_Cbte,'
		SET @SqlStr +=	' CONVERT(INT, CI.Cantidad) AS Cantidad,'
		SET @SqlStr +=	' CB.Lote,'
		SET @SqlStr +=	' PR.Id_Sector,'
		SET @SqlStr +=	' S.Codigo AS Sector_Codigo,'
		SET @SqlStr +=	' S.Descripcion AS Sector_Nombre,'
		SET @SqlStr +=	' PR.Columna,'
		SET @SqlStr +=	' PR.Fila,'
		SET @SqlStr +=	' PLP.Fecha_Evento'
		SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT, Empresas_Sedes_Sectores S'
		SET @SqlStr +=	' WHERE'
		SET @SqlStr +=	' CB.Id_Trans = CI.Id_Trans'
		SET @SqlStr +=	' AND CI.Id_Producto = PR.Id_Producto'
		SET @SqlStr +=	' AND PR.Id_Sector = S.Id_Sector'
		SET @SqlStr +=	' AND CI.Id_Cliente = CL.Id_Cliente'
		SET @SqlStr +=	' AND CB.Id_Lista = PLP.Id_Lista_Precio'
		SET @SqlStr +=	' AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte'
		SET @SqlStr +=	' AND (CT.Compromete_Factura = 1 OR Compromete_Remitos = 1) ' 
		SET @SqlStr +=	' AND CB.Id_Estado_Cbte IN (2,4) '
		SET @SqlStr +=	' AND PLP.Flag_Localidades = 1'
		SET @SqlStr +=	' AND PR.Tipo = ''L'''
		SET @SqlStr +=	' AND CI.Flag_QA IN (''A'',''B'')'
		SET @SqlStr +=	' AND DATEADD(DAY, (-1) * PLP.Evento_Cant_Dias_Renov_Prev, CONVERT(DATE, CI.Fecha_Venc)) <= CONVERT(DATE, GETDATE())
										AND CONVERT(DATE, CI.Fecha_Venc) >= CONVERT(DATE, GETDATE())  '
						  
		IF(@pId_Cliente <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND (CL.Id_Cliente = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) +  ' OR CL.Id_Cliente_Ref = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) + ')'
		END

		IF(@pId_Lista_Precio > 0)
		BEGIN
			IF(@Id_Evento_Grupo <> 0)
			BEGIN
				SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio IN (SELECT PLG.Id_Lista_Precio 
																							FROM Prod_Listas_Precios PLG
																							WHERE PLG.Id_Evento_Grupo IN (' + CONVERT(VARCHAR(10), @Id_Evento_Grupo) + ','+ CONVERT(VARCHAR(10), @Id_Evento_Grupo_Reservas) + ')
																							AND PLG.Flag_Localidades = 1)'
			END
		END

		IF(@pId_Producto <> '')
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Producto = ''' + @pId_Producto +''''
		END

		IF(@pId_Trans <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND CB.Id_Trans = ' + @pId_Trans 
		END


		IF(@pId_Sector <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
		END

		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@SqlStr: ' + @SqlStr
		END

		EXECUTE sp_executesql @SqlStr
	END 

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
	END
END
/*======================================================================= RESERVAS VENCIDAS=============================================================================*/
IF @pInc_AbonosReser = 1
BEGIN 
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'RESERVAS VENCIDAS'
		PRINT '@Evento_Fecha_Reserva_Limite : ' + CONVERT(VARCHAR(10), @Evento_Fecha_Reserva_Limite, 112)
	END

	IF CONVERT(DATE,@Evento_Fecha_Reserva_Limite) >= CONVERT(DATE,GETDATE()) 
	BEGIN
		IF(@pId_Lista_Precio > 0)
		BEGIN
			IF(@Id_Evento_Grupo <> 0)
			BEGIN
				SELECT PLG.Id_Lista_Precio
				INTO #Temp_Prod_Listas_Precios
				FROM Prod_Listas_Precios PLG
				WHERE 
				PLG.Id_Evento_Grupo IN ( @Id_Evento_Grupo, @Id_Evento_Grupo_Reservas)
				AND PLG.Flag_Localidades = 1
			END
		END

		SET @SqlStr =	''

		SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Localidades_Ocupadas '
		SET @SqlStr +=	' SELECT'
		SET @SqlStr +=	' DISTINCT'
		SET @SqlStr +=	' CB.Id_Trans,'
		SET @SqlStr +=	' ISNULL(CI.Id_Cliente, 0) AS Id_Cliente,'
		SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0) AS Id_Lista,'
		SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '''')))) AS Razon_Social,'
		SET @SqlStr +=	' CI.Fecha_QA,'
		SET @SqlStr +=	' CI.Fecha_Venc,'
		SET @SqlStr +=	' PLP.Fecha_Desde,'
		SET @SqlStr +=	' PLP.Fecha_Hasta,'
		SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(PLP.Descripcion, '''')))) AS Descripcion,'
		SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CI.Id_Producto, '''')))) AS Id_Producto,'
		SET @SqlStr +=	' UPPER(RTRIM(LTRIM(ISNULL(PR.Descripcion_Resumida, '''')))) AS Descripcion_Resumida,'
		SET @SqlStr +=	' ''AR'' AS Estado,'
					/*
						A	-> Abono Comprado       
						ARA -> Abono Reserva Anticipada    
						AR	-> Abono Resevado     
						TV	-> Ticket Vendido
						TC	-> Ticket Canjeado
						TI	-> Ticket Impreso
						PI	-> Protocolos Impresos
						PU	-> Protocolo Fijo
						PV	-> En Proceso de Venta
					*/
		SET @SqlStr +=	' CI.Serie,'
		SET @SqlStr +=	' CI.Item,'
		SET @SqlStr +=	' CI.Flag_QA,'
		SET @SqlStr +=	' CB.Fecha,'
		SET @SqlStr +=	' dbo.CF_Cbte_Descrip(CB.Id_Trans) AS Cbte_Descrip,'
		SET @SqlStr +=	' CB.Id_Estado_Cbte,'
		SET @SqlStr +=	' CONVERT(INT, CI.Cantidad) AS Cantidad,'
		SET @SqlStr +=	' CB.Lote,'
		SET @SqlStr +=	' PR.Id_Sector,'
		SET @SqlStr +=	' S.Codigo AS Sector_Codigo,'
		SET @SqlStr +=	' S.Descripcion AS Sector_Nombre,'
		SET @SqlStr +=	' PR.Columna,'
		SET @SqlStr +=	' PR.Fila,'
		SET @SqlStr +=	' PLP.Fecha_Evento'

		IF CONVERT(DATE,@Evento_Fecha_Reserva_Limite) >= CONVERT(DATE,GETDATE()) 
		BEGIN
			IF(@pId_Lista_Precio > 0)
			BEGIN
				IF(@Id_Evento_Grupo <> 0)
				BEGIN
					SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT, Empresas_Sedes_Sectores S, #Temp_Prod_Listas_Precios Z'
				END
				ELSE
				BEGIN
					SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT, Empresas_Sedes_Sectores S'
				END
			END
			ELSE
			BEGIN
				SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT, Empresas_Sedes_Sectores S'
			END
		END


		SET @SqlStr +=	' WHERE'
		SET @SqlStr +=	' CB.Id_Trans = CI.Id_Trans'
		SET @SqlStr +=	' AND CI.Id_Producto = PR.Id_Producto'
		SET @SqlStr +=	' AND PR.Id_Sector = S.Id_Sector'
		SET @SqlStr +=	' AND CI.Id_Cliente = CL.Id_Cliente'
		SET @SqlStr +=	' AND CB.Id_Lista = PLP.Id_Lista_Precio'
		SET @SqlStr +=	' AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte'
		SET @SqlStr +=	' AND (CT.Compromete_Factura = 1 OR Compromete_Remitos = 1) ' 
		SET @SqlStr +=	' AND CB.Id_Estado_Cbte IN (2,4) '
		SET @SqlStr +=	' AND PLP.Flag_Localidades = 1'
		SET @SqlStr +=	' AND PR.Tipo = ''L'''
		SET @SqlStr +=	' AND NOT EXISTS (SELECT 1 FROM #Rta_CPJ_Localidades_Ocupadas AUXRTA WHERE AUXRTA.ID_TRANS = CI.ID_TRANS AND AUXRTA.ITEM = CI.ITEM)'
		SET @SqlStr +=	' AND CI.Flag_QA IN (''A'',''B'')'
		SET @SqlStr +=	' AND DATEADD(DAY, PLP.Evento_Cant_Dias_Limite, CONVERT(DATE, CI.Fecha_Venc)) >= CONVERT(DATE, GETDATE())
										AND CONVERT(DATE, CI.Fecha_Venc) <= CONVERT(DATE, GETDATE()) '
						  
		IF(@pId_Cliente <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND (CL.Id_Cliente = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) +  ' OR CL.Id_Cliente_Ref = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) + ')'
		END

		IF(@pId_Lista_Precio > 0)
		BEGIN
			IF(@Id_Evento_Grupo <> 0)
			BEGIN
				SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio = Z.Id_Lista_Precio'				
			END
		END
	
		IF(@pId_Sector <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
		END


		IF(@pId_Producto <> '')
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Producto = ''' + @pId_Producto +''''
		END

		IF(@pId_Trans <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND CB.Id_Trans = ' + @pId_Trans 
		END



		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@SqlStr: ' + @SqlStr
		END

		EXECUTE sp_executesql @SqlStr
	END 

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
	END
END
	/*=======================================================================VENTAS y REMITOS de ABONOS =============================================================================*/
IF  @pInc_Abonos = 1
BEGIN
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'VENTAS y REMITOS de ABONOS'
	END

	SET @SqlStr =	''

	SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Localidades_Ocupadas '
	SET @SqlStr +=	' SELECT'
	SET @SqlStr +=	' DISTINCT'
	SET @SqlStr +=	' CB.Id_Trans,'
	SET @SqlStr +=	' ISNULL(CI.Id_Cliente, 0) AS Id_Cliente,'
	SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0) AS Id_Lista,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '''')))) AS Razon_Social,'
	SET @SqlStr +=	' CI.Fecha_QA,'
	SET @SqlStr +=	' CI.Fecha_Venc,'
	SET @SqlStr +=	' PLP.Fecha_Desde,'
	SET @SqlStr +=	' PLP.Fecha_Hasta,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(PLP.Descripcion, '''')))) AS Descripcion,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CI.Id_Producto, '''')))) AS Id_Producto,'
	SET @SqlStr +=	' UPPER(RTRIM(LTRIM(ISNULL(PR.Descripcion_Resumida, '''')))) AS Descripcion_Resumida,'
	SET @SqlStr +=	'''A'' AS Estado,'
					/*
						A	-> Abono Comprado      
						ARA -> Abono Reserva Anticipada    
						AR	-> Abono Reservado     
						TV	-> Ticket Vendido
						TC	-> Ticket Canjeado
						TI	-> Ticket Impreso
						PI	-> Protocolos Impresos
						PU	-> Protocolo Fijo
						PV	-> En Proceso de Venta
					*/
	SET @SqlStr +=	' CI.Serie,'
	SET @SqlStr +=	' CI.Item,'
	SET @SqlStr +=	' CI.Flag_QA,'
	SET @SqlStr +=	' CB.Fecha,'
	SET @SqlStr +=	' dbo.CF_Cbte_Descrip(CB.Id_Trans) AS Cbte_Descrip,'
	SET @SqlStr +=	' CB.Id_Estado_Cbte,'
	SET @SqlStr +=	' CONVERT(INT, CI.Cantidad) AS Cantidad,'
	SET @SqlStr +=	' CB.Lote,'
	SET @SqlStr +=	' PR.Id_Sector,'
	SET @SqlStr +=	' S.Codigo AS Sector_Codigo,'
	SET @SqlStr +=	' S.Descripcion AS Sector_Nombre,'
	SET @SqlStr +=	' PR.Columna,'
	SET @SqlStr +=	' PR.Fila,'
	SET @SqlStr +=	' PLP.Fecha_Evento'
	SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT, Empresas_Sedes_Sectores S'
	SET @SqlStr +=	' WHERE'
	SET @SqlStr +=	' CB.Id_Trans = CI.Id_Trans'
	SET @SqlStr +=	' AND CI.Id_Producto = PR.Id_Producto'
	SET @SqlStr +=	' AND PR.Id_Sector = S.Id_Sector'
	SET @SqlStr +=	' AND CI.Id_Cliente = CL.Id_Cliente'
	SET @SqlStr +=	' AND CB.Id_Lista = PLP.Id_Lista_Precio'
	SET @SqlStr +=	' AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte'
	SET @SqlStr +=	' AND (CT.Compromete_Factura = 1 OR Compromete_Remitos = 1) ' 
	SET @SqlStr +=	' AND CB.Id_Estado_Cbte IN (2,4,1) ' --25/04/2022 Se agrega estado 1
	SET @SqlStr +=	' AND PLP.Flag_Localidades = 1'
	SET @SqlStr +=	' AND PR.Tipo = ''L'''
	SET @SqlStr +=	' AND NOT EXISTS (SELECT 1 FROM #Rta_CPJ_Localidades_Ocupadas AUXRTA WHERE AUXRTA.ID_TRANS = CI.ID_TRANS AND AUXRTA.ITEM = CI.ITEM)'
	SET @SqlStr +=	' AND CI.Flag_QA IN (''A'',''B'')'
	SET @SqlStr +=  ' AND CI.Fecha_QA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @Evento_Hasta), 112) +'''
					  AND CI.Fecha_Venc >=  ''' + CONVERT(VARCHAR(10), @Evento_Desde, 112) +''''

	IF(@pId_Cliente <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND (CL.Id_Cliente = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) +  ' OR CL.Id_Cliente_Ref = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) + ')'
	END

	IF(@pId_Lista_Precio > 0)
	BEGIN
		IF(@Id_Evento_Grupo <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio IN (	SELECT PLG.Id_Lista_Precio 
																							FROM Prod_Listas_Precios PLG
																							WHERE 
																							PLG.Id_Evento_Grupo = ' + CONVERT(VARCHAR(10), @Id_Evento_Grupo) + '
																							AND PLG.Flag_Localidades = 1)'
		END
		ELSE
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio = '+ CONVERT(VARCHAR(10),@pId_Lista_Precio)
		END
	END

	
	IF(@pId_Sector <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
	END

	IF(@pId_Producto <> '')
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Producto = ''' + @pId_Producto +''''
	END

	IF(@pId_Trans <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND CB.Id_Trans = ' + @pId_Trans 
	END


	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@SqlStr: ' + @SqlStr
	END

	EXECUTE sp_executesql @SqlStr

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
	END
END
	/*=======================================================================VENTAS y REMITOS de Fechas(Partidos) CON PRECIO  =============================================================================*/
IF @pInc_TicketVend =  1
BEGIN
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'VENTAS y REMITOS DE FECHAS (PARTIDOS) CON PRECIO'
	END

	SET @Tipo_Cbte_VW_Factura	= LTRIM(RTRIM(dbo.CF_xParam('Tipo_Cbte_VW_Factura')))

	SET @SqlStr =	''

	SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Localidades_Ocupadas '
	SET @SqlStr +=	' SELECT'
	SET @SqlStr +=	' DISTINCT'
	SET @SqlStr +=	' CB.Id_Trans,'
	SET @SqlStr +=	' ISNULL(CI.Id_Cliente, 0) AS Id_Cliente,'
	SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0) AS Id_Lista,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '''')))) AS Razon_Social,'
	SET @SqlStr +=	' CI.Fecha_QA,'
	SET @SqlStr +=	' CI.Fecha_Venc,'
	SET @SqlStr +=	' PLP.Fecha_Desde,'
	SET @SqlStr +=	' PLP.Fecha_Hasta,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(PLP.Descripcion, '''')))) AS Descripcion,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CI.Id_Producto, '''')))) AS Id_Producto,'
	SET @SqlStr +=	' UPPER(RTRIM(LTRIM(ISNULL(PR.Descripcion_Resumida, '''')))) AS Descripcion_Resumida,'
	SET @SqlStr +=	'''TV'' AS Estado,'
					/*
						A	-> Abono Comprado    
						ARA -> Abono Reserva Anticipada    
						AR	-> Abono Resevado     
						TV	-> Ticket Vendido
						TC	-> Ticket Canjeado
						TI	-> Ticket Impreso
						PI	-> Protocolos Impresos
						PU	-> Protocolo Fijo
						PV	-> En Proceso de Venta
					*/
	SET @SqlStr +=	' CI.Serie,'
	SET @SqlStr +=	' CI.Item,'
	SET @SqlStr +=	' CI.Flag_QA,'
	SET @SqlStr +=	' CB.Fecha,'
	SET @SqlStr +=	' dbo.CF_Cbte_Descrip(CB.Id_Trans) AS Cbte_Descrip,'
	SET @SqlStr +=	' CB.Id_Estado_Cbte,'
	SET @SqlStr +=	' CONVERT(INT, CI.Cantidad) AS Cantidad,'
	SET @SqlStr +=	' CB.Lote,'
	SET @SqlStr +=	' PR.Id_Sector,'
	SET @SqlStr +=	' S.Codigo AS Sector_Codigo,'
	SET @SqlStr +=	' S.Descripcion AS Sector_Nombre,'
	SET @SqlStr +=	' PR.Columna,'
	SET @SqlStr +=	' PR.Fila,'
	SET @SqlStr +=	' PLP.Fecha_Evento'
	SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT, Empresas_Sedes_Sectores S'
	SET @SqlStr +=	' WHERE'
	SET @SqlStr +=	' CB.Id_Trans = CI.Id_Trans'
	SET @SqlStr +=	' AND CI.Id_Producto = PR.Id_Producto'
	SET @SqlStr +=	' AND PR.Id_Sector = S.Id_Sector'
	SET @SqlStr +=	' AND CI.Id_Cliente = CL.Id_Cliente'
	SET @SqlStr +=	' AND CB.Id_Lista = PLP.Id_Lista_Precio'
	SET @SqlStr +=	' AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte'
	SET @SqlStr +=	' AND (CT.Compromete_Factura = 1 OR Compromete_Remitos = 1) ' 
	SET @SqlStr +=	' AND CB.Id_Estado_Cbte IN (2,4,1) '	--25/04/2022 Se agrega estado 1
	SET @SqlStr +=	' AND PLP.Flag_Localidades = 2'
	SET @SqlStr +=	' AND NOT EXISTS (SELECT 1 FROM #Rta_CPJ_Localidades_Ocupadas AUXRTA WHERE AUXRTA.ID_TRANS = CI.ID_TRANS AND AUXRTA.ITEM = CI.ITEM)'
	SET @SqlStr +=	' AND CONVERT(DATE,PLP.Fecha_Hasta) >= CONVERT(DATE,GETDATE()) '	--25/04/2022 Se pone Fecha_Hasta (Periodo/Habilitar ingresos hasta), hasta ese momento la entrada va a figurar ocupada --06/05/2022 SE AGREGA CONVERT PARA NO VALIDAR LA HORA
	SET @SqlStr +=	' AND PR.Tipo = ''L'''
	SET @SqlStr +=	' AND CI.Flag_QA IN (''A'',''B'')'

	IF @Flag_Localidades = 2
	BEGIN
		SET @SqlStr +=	' AND CONVERT(VARCHAR(8),PLP.Fecha_Evento,112) = '''+ CONVERT(VARCHAR(8),@Fecha_Evento,112) +''''
    END

	IF(@pId_Cliente <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND (CL.Id_Cliente = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) +  ' OR CL.Id_Cliente_Ref = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) + ')'
	END

	IF(@pId_Lista_Precio > 0)
	BEGIN
		IF(@Id_Evento_Grupo <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio IN (SELECT PLG.Id_Lista_Precio 
																						   FROM Prod_Listas_Precios PLG
																						   WHERE 
																						   PLG.Id_Evento_Grupo = ' + CONVERT(VARCHAR(10), @Id_Evento_Grupo) + '
																						   AND PLG.Flag_Localidades = 2)'
		END
		ELSE
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio = '+ CONVERT(VARCHAR(10),@pId_Lista_Precio)
		END 
	END
	
	IF(@pId_Sector <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
	END

	IF(@pId_Producto <> '')
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Producto = ''' + @pId_Producto +''''
	END

	IF(@pId_Trans <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND CB.Id_Trans = ' + @pId_Trans 
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@SqlStr: ' + @SqlStr
	END

	EXECUTE sp_executesql @SqlStr

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
	END
END
	/*=======================================================================VENTAS y REMITOS de Fechas(Partidos) SIN PRECIO (CANJES)===========================================================================*/
IF @pInc_TicketCanj = 1
BEGIN 
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'VENTAS y REMITOS DE FECHAS (PARTIDOS) SIN PRECIO (CANJES)'
	END

	SET @Tipo_Cbte_VW_Pedido	= LTRIM(RTRIM(dbo.CF_xParam('Tipo_Cbte_VW_Pedido')))

	SET @SqlStr =	''

	SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Localidades_Ocupadas '
	SET @SqlStr +=	' SELECT'
	SET @SqlStr +=	' DISTINCT'
	SET @SqlStr +=	' CB.Id_Trans,'
	SET @SqlStr +=	' ISNULL(CI.Id_Cliente, 0) AS Id_Cliente,'
	SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0) AS Id_Lista,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '''')))) AS Razon_Social,'
	SET @SqlStr +=	' CI.Fecha_QA,'
	SET @SqlStr +=	' CI.Fecha_Venc,'
	SET @SqlStr +=	' PLP.Fecha_Desde,'
	SET @SqlStr +=	' PLP.Fecha_Hasta,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(PLP.Descripcion, '''')))) AS Descripcion,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CI.Id_Producto, '''')))) AS Id_Producto,'
	SET @SqlStr +=	' UPPER(RTRIM(LTRIM(ISNULL(PR.Descripcion_Resumida, '''')))) AS Descripcion_Resumida,'
	SET @SqlStr +=	'''TC'' AS Estado,'
					/*
						A	-> Abono Comprado    
						ARA -> Abono Reserva Anticipada    
						AR	-> Abono Resevado     
						TV	-> Ticket Vendido
						TC	-> Ticket Canjeado
						TI	-> Ticket Impreso
						PI	-> Protocolos Impresos
						PU	-> Protocolo Fijo
						PV	-> En Proceso de Venta
					*/
	SET @SqlStr +=	' CI.Serie,'
	SET @SqlStr +=	' CI.Item,'
	SET @SqlStr +=	' CI.Flag_QA,'
	SET @SqlStr +=	' CB.Fecha,'
	SET @SqlStr +=	' dbo.CF_Cbte_Descrip(CB.Id_Trans) AS Cbte_Descrip,'
	SET @SqlStr +=	' CB.Id_Estado_Cbte,'
	SET @SqlStr +=	' CONVERT(INT, CI.Cantidad) AS Cantidad,'
	SET @SqlStr +=	' CB.Lote,'
	SET @SqlStr +=	' PR.Id_Sector,'
	SET @SqlStr +=	' S.Codigo AS Sector_Codigo,'
	SET @SqlStr +=	' S.Descripcion AS Sector_Nombre,'
	SET @SqlStr +=	' PR.Columna,'
	SET @SqlStr +=	' PR.Fila,'
	SET @SqlStr +=	' PLP.Fecha_Evento'
	SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT, Empresas_Sedes_Sectores S'
	SET @SqlStr +=	' WHERE'
	SET @SqlStr +=	' CB.Id_Trans = CI.Id_Trans'
	SET @SqlStr +=	' AND CI.Id_Producto = PR.Id_Producto'
	SET @SqlStr +=	' AND PR.Id_Sector = S.Id_Sector'
	SET @SqlStr +=	' AND CI.Id_Cliente = CL.Id_Cliente'
	SET @SqlStr +=	' AND CB.Id_Lista = PLP.Id_Lista_Precio'
	SET @SqlStr +=	' AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte'
	SET @SqlStr +=	' AND CT.Compromete_Pedido = 1 ' 
	SET @SqlStr +=	' AND CT.Id_Tipo_Cbte = ''' + @Tipo_Cbte_VW_Pedido + ''''
	SET @SqlStr +=	' AND CB.Id_Estado_Cbte IN (1,2,4) '
	SET @SqlStr +=	' AND PLP.Flag_Localidades = 2'
	SET @SqlStr +=	' AND NOT EXISTS (SELECT 1 FROM #Rta_CPJ_Localidades_Ocupadas AUXRTA WHERE AUXRTA.ID_TRANS = CI.ID_TRANS AND AUXRTA.ITEM = CI.ITEM)'
	SET @SqlStr +=	' AND CONVERT(DATE,PLP.Fecha_Hasta) >= CONVERT(DATE,GETDATE()) ' --25/04/2022 Se pone Fecha_Hasta (Periodo/Habilitar ingresos hasta), hasta ese momento la entrada va a figurar ocupada --06/05/2022 SE AGREGA CONVERT PARA NO VALIDAR LA HORA
	SET @SqlStr +=	' AND PR.Tipo = ''L'''
	SET @SqlStr +=	' AND CI.Flag_QA IN (''A'',''B'')'

	IF @Flag_Localidades = 2
	BEGIN
		SET @SqlStr +=	' AND CONVERT(VARCHAR(8),PLP.Fecha_Evento,112) = '''+ CONVERT(VARCHAR(8),@Fecha_Evento,112) +''''
    END

	IF(@pId_Cliente <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND (CL.Id_Cliente = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) +  ' OR CL.Id_Cliente_Ref = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) + ')'
	END

	IF(@pId_Lista_Precio > 0)
	BEGIN
		IF(@Id_Evento_Grupo <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio IN (SELECT PLG.Id_Lista_Precio 
																						   FROM Prod_Listas_Precios PLG
																						   WHERE 
																						   PLG.Id_Evento_Grupo = ' + CONVERT(VARCHAR(10), @Id_Evento_Grupo) + '
																						   AND PLG.Flag_Localidades = 2)'
		END
		ELSE
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio = '+ CONVERT(VARCHAR(10),@pId_Lista_Precio)
		END 
	END

	
	IF(@pId_Sector <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
	END

	IF(@pId_Producto <> '')
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Producto = ''' + @pId_Producto +''''
	END

	IF(@pId_Trans <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND CB.Id_Trans = ' + @pId_Trans 
	END



	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@SqlStr: ' + @SqlStr
	END

	EXECUTE sp_executesql @SqlStr

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
	END
END
/*======================================================================= TICKETS IMPRESOS para fechas o partidos (no abonos) NO FIJOS UBICABLE=============================================================================*/
IF @pInc_TicketImp = 1
BEGIN

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'TICKETS IMPRESOS PARA FECHAS(PARTIDOS, NO abonos) NO FIJOS/NO UBICABLES'
	END

	SET @SqlStr =	''

	SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Localidades_Ocupadas '
	SET @SqlStr +=	' SELECT'
	SET @SqlStr +=	' DISTINCT'
	SET @SqlStr +=	' CB.Id_Trans,'
	SET @SqlStr +=	' ISNULL(CI.Id_Cliente, 0) AS Id_Cliente,'
	SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0) AS Id_Lista,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '''')))) AS Razon_Social,'
	SET @SqlStr +=	' CI.Fecha_QA,'
	SET @SqlStr +=	' CI.Fecha_Venc,'
	SET @SqlStr +=	' PLP.Fecha_Desde,'
	SET @SqlStr +=	' PLP.Fecha_Hasta,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(PLP.Descripcion, '''')))) AS Descripcion,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CI.Id_Producto, '''')))) AS Id_Producto,'
	SET @SqlStr +=	' UPPER(RTRIM(LTRIM(ISNULL(PR.Descripcion_Resumida, '''')))) AS Descripcion_Resumida,'
	SET @SqlStr +=	'''TI'' AS Estado,'
					/*
						A	-> Abono Comprado    
						ARA -> Abono Reserva Anticipada    
						AR	-> Abono Resevado     
						TV	-> Ticket Vendido
						TC	-> Ticket Canjeado
						TI	-> Ticket Impreso
						PI	-> Protocolos Impresos
						PU	-> Protocolo Fijo
						PV	-> En Proceso de Venta
					*/
	SET @SqlStr +=	' CI.Serie,'
	SET @SqlStr +=	' CI.Item,'
	SET @SqlStr +=	' CI.Flag_QA,'
	SET @SqlStr +=	' CB.Fecha,'
	SET @SqlStr +=	' dbo.CF_Cbte_Descrip(CB.Id_Trans) AS Cbte_Descrip,'
	SET @SqlStr +=	' CB.Id_Estado_Cbte,'
	SET @SqlStr +=	' CONVERT(INT, CI.Cantidad) AS Cantidad,'
	SET @SqlStr +=	' CB.Lote,'
	SET @SqlStr +=	' PR.Id_Sector,'
	SET @SqlStr +=	' S.Codigo AS Sector_Codigo,'
	SET @SqlStr +=	' S.Descripcion AS Sector_Nombre,'
	SET @SqlStr +=	' PR.Columna,'
	SET @SqlStr +=	' PR.Fila,'
	SET @SqlStr +=	' PLP.Fecha_Evento'
	SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT, Empresas_Sedes_Sectores S'
	SET @SqlStr +=	' WHERE'
	SET @SqlStr +=	' CB.Id_Trans = CI.Id_Trans'
	SET @SqlStr +=	' AND CI.Id_Producto = PR.Id_Producto'
	SET @SqlStr +=	' AND PR.Id_Sector = S.Id_Sector'
	SET @SqlStr +=	' AND CI.Id_Cliente = CL.Id_Cliente'
	SET @SqlStr +=	' AND CB.Id_Lista = PLP.Id_Lista_Precio'
	SET @SqlStr +=	' AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte'
	SET @SqlStr +=	' AND CT.Compromete_Pedido = 1 ' 
	SET @SqlStr +=	' AND CB.Id_Tipo_Cbte = '''+  dbo.CF_xParam('Loca_Cbte_Loca_Ent') +''''
	SET @SqlStr +=	' AND CB.Id_Estado_Cbte IN (1,2,4) '
	SET @SqlStr +=	' AND PLP.Flag_Localidades = 2 '
	SET @SqlStr +=	' AND NOT EXISTS (SELECT 1 FROM #Rta_CPJ_Localidades_Ocupadas AUXRTA WHERE AUXRTA.ID_TRANS = CI.ID_TRANS AND AUXRTA.ITEM = CI.ITEM)'
	SET @SqlStr +=	' AND CONVERT(DATE,PLP.Fecha_Hasta) >= CONVERT(DATE,GETDATE()) ' --25/04/2022 Se pone Fecha_Hasta (Periodo/Habilitar ingresos hasta), hasta ese momento la entrada va a figurar ocupada --06/05/2022 SE AGREGA CONVERT PARA NO VALIDAR LA HORA
	SET @SqlStr +=	' AND PR.Tipo = ''L'''
	SET @SqlStr +=	' AND CI.Flag_QA IN (''A'',''B'')'

	IF @Flag_Localidades = 2
	BEGIN
		SET @SqlStr +=	' AND CONVERT(VARCHAR(8),PLP.Fecha_Evento,112) = '''+ CONVERT(VARCHAR(8),@Fecha_Evento,112) +''''
	END

	IF(@pId_Cliente <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND (CL.Id_Cliente = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) +  ' OR CL.Id_Cliente_Ref = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) + ')'
	END

	IF(@pId_Lista_Precio > 0)
	BEGIN
		IF(@Id_Evento_Grupo <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio IN (SELECT PLG.Id_Lista_Precio 
																							FROM Prod_Listas_Precios PLG
																							WHERE
																							PLG.Id_Evento_Grupo = ' + CONVERT(VARCHAR(10), @Id_Evento_Grupo) + '
																							AND PLG.Flag_Localidades = 2)'
		END
		ELSE
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio = '+ CONVERT(VARCHAR(10),@pId_Lista_Precio)
		END 
	END
	
	IF(@pId_Sector <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
	END

	IF(@pId_Producto <> '')
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Producto = ''' + @pId_Producto +''''
	END

	IF(@pId_Trans <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND CB.Id_Trans = ' + @pId_Trans 
	END


	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@SqlStr: ' + @SqlStr
	END

	EXECUTE sp_executesql @SqlStr

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
	END
END
/*======================================================================= PROTOCOLOS IMPRESOS para fechas o partidos (no abonos) NO FIJOS UBICABLE=============================================================================*/
IF @pInc_ProtoImp = 1
BEGIN
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'PROTOCOLOS IMPRESOS PARA FECHAS(PARTIDOS, NO abonos) NO FIJOS/NO UBICABLES'
	END

	SET @SqlStr =	''

	SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Localidades_Ocupadas '
	SET @SqlStr +=	' SELECT'
	SET @SqlStr +=	' DISTINCT'
	SET @SqlStr +=	' CB.Id_Trans,'
	SET @SqlStr +=	' ISNULL(CI.Id_Cliente, 0) AS Id_Cliente,'
	SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0) AS Id_Lista,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '''')))) AS Razon_Social,'
	SET @SqlStr +=	' CI.Fecha_QA,'
	SET @SqlStr +=	' CI.Fecha_Venc,'
	SET @SqlStr +=	' PLP.Fecha_Desde,'
	SET @SqlStr +=	' PLP.Fecha_Hasta,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(PLP.Descripcion, '''')))) AS Descripcion,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CI.Id_Producto, '''')))) AS Id_Producto,'
	SET @SqlStr +=	' UPPER(RTRIM(LTRIM(ISNULL(PR.Descripcion_Resumida, '''')))) AS Descripcion_Resumida,'
	SET @SqlStr +=	'''PI'' AS Estado,'
					/*
						A	-> Abono Comprado    
						ARA -> Abono Reserva Anticipada    
						AR	-> Abono Resevado     
						TV	-> Ticket Vendido
						TC	-> Ticket Canjeado
						TI	-> Ticket Impreso
						PI	-> Protocolos Impresos
						PU	-> Protocolo Fijo
						PV	-> En Proceso de Venta
					*/
	SET @SqlStr +=	' CI.Serie,'
	SET @SqlStr +=	' CI.Item,'
	SET @SqlStr +=	' CI.Flag_QA,'
	SET @SqlStr +=	' CB.Fecha,'
	SET @SqlStr +=	' dbo.CF_Cbte_Descrip(CB.Id_Trans) AS Cbte_Descrip,'
	SET @SqlStr +=	' CB.Id_Estado_Cbte,'
	SET @SqlStr +=	' CONVERT(INT, CI.Cantidad) AS Cantidad,'
	SET @SqlStr +=	' CB.Lote,'
	SET @SqlStr +=	' PR.Id_Sector,'
	SET @SqlStr +=	' S.Codigo AS Sector_Codigo,'
	SET @SqlStr +=	' S.Descripcion AS Sector_Nombre,'
	SET @SqlStr +=	' PR.Columna,'
	SET @SqlStr +=	' PR.Fila,'
	SET @SqlStr +=	' PLP.Fecha_Evento'
	SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT, Empresas_Sedes_Sectores S'
	SET @SqlStr +=	' WHERE'
	SET @SqlStr +=	' CB.Id_Trans = CI.Id_Trans'
	SET @SqlStr +=	' AND CI.Id_Producto = PR.Id_Producto'
	SET @SqlStr +=	' AND PR.Id_Sector = S.Id_Sector'
	SET @SqlStr +=	' AND CI.Id_Cliente = CL.Id_Cliente'
	SET @SqlStr +=	' AND CB.Id_Lista = PLP.Id_Lista_Precio'
	SET @SqlStr +=	' AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte'
	SET @SqlStr +=	' AND CT.Compromete_Pedido = 1 ' 
	SET @SqlStr +=	' AND CB.Id_Tipo_Cbte = '''+  dbo.CF_xParam('Id_Cbte_Ent_Prot') +'''' 
	SET @SqlStr +=	' AND CB.Id_Estado_Cbte IN (1,2,4) '
	SET @SqlStr +=	' AND PLP.Flag_Localidades = 2'
	SET @SqlStr +=	' AND NOT EXISTS (SELECT 1 FROM #Rta_CPJ_Localidades_Ocupadas AUXRTA WHERE AUXRTA.ID_TRANS = CI.ID_TRANS AND AUXRTA.ITEM = CI.ITEM)'
	SET @SqlStr +=	' AND CONVERT(DATE,PLP.Fecha_Hasta) >= CONVERT(DATE,GETDATE()) ' --25/04/2022 Se pone Fecha_Hasta (Periodo/Habilitar ingresos hasta), hasta ese momento la entrada va a figurar ocupada --06/05/2022 SE AGREGA CONVERT PARA NO VALIDAR LA HORA
	SET @SqlStr +=	' AND PR.Tipo = ''L'''
	SET @SqlStr +=	' AND CI.Flag_QA IN (''A'',''B'')'

	IF @Flag_Localidades = 2
	BEGIN
		SET @SqlStr +=	' AND CONVERT(VARCHAR(8),PLP.Fecha_Evento,112) = '''+ CONVERT(VARCHAR(8),@Fecha_Evento,112) +''''
    END

	IF(@pId_Cliente <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND (CL.Id_Cliente = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) +  ' OR CL.Id_Cliente_Ref = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) + ')'
	END

	IF(@pId_Lista_Precio > 0)
	BEGIN
		IF(@Id_Evento_Grupo <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio IN (SELECT PLG.Id_Lista_Precio 
																						   FROM Prod_Listas_Precios PLG
																						   WHERE 
																						   PLG.Id_Evento_Grupo = ' + CONVERT(VARCHAR(10), @Id_Evento_Grupo) + '
																						   AND PLG.Flag_Localidades = 2)'
		END
		ELSE
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio = '+ CONVERT(VARCHAR(10),@pId_Lista_Precio)
		END 
	END
	
	IF(@pId_Sector <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
	END

	IF(@pId_Producto <> '')
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Producto = ''' + @pId_Producto +''''
	END

	IF(@pId_Trans <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND CB.Id_Trans = ' + @pId_Trans 
	END


	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@SqlStr: ' + @SqlStr
	END

	EXECUTE sp_executesql @SqlStr

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
	END
END
	/*========================================================================PROTOCOLOS FIJOS============================================================================*/
IF @pInc_ProtoFijos	= 1
BEGIN
	IF (@pId_Cliente = 0)
	BEGIN	
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'PROTOCOLOS FIJOS'
		END

		SET @SqlStr =	''

		SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Localidades_Ocupadas '
		SET @SqlStr +=	' SELECT'
		SET @SqlStr +=	' 0 AS Id_Trans,'
		SET @SqlStr +=	' 0 AS Id_Cliente,'
		SET @SqlStr +=	' 0 AS Id_Lista,'
		SET @SqlStr +=	' '''' AS Razon_Social,'
		SET @SqlStr +=	' '''' AS Fecha_QA,'
		SET @SqlStr +=	' '''' AS Fecha_Venc,'
		SET @SqlStr +=	' '''' AS Fecha_Desde,'
		SET @SqlStr +=	' '''' AS Fecha_Hasta,'
		SET @SqlStr +=	' '''' AS Descripcion,'
		SET @SqlStr +=	' I.Id_Producto AS Id_Producto,'
		SET @SqlStr +=	' '''' AS Descripcion_Resumida,'
		SET @SqlStr +=	' ''PU'' AS Estado,'
					/*
						A	-> Abono Comprado     
						ARA -> Abono Reserva Anticipada    
						AR	-> Abono Resevado     
						TV	-> Ticket Vendido
						TC	-> Ticket Canjeado
						TI	-> Ticket Impreso
						PI	-> Protocolos Impresos
						PU	-> Protocolo Fijo
						PV	-> En Proceso de Venta
					*/
		SET @SqlStr +=	' '''' AS Serie,'
		SET @SqlStr +=	' 0 AS Item,'
		SET @SqlStr +=	' '''' AS Flag_QA,'
		SET @SqlStr +=	' '''' AS Fecha_Cbte,'
		SET @SqlStr +=	' '''' AS Cbte_Descrip,'
		SET @SqlStr +=	' 0 AS Id_Estado_Cbte,'
		SET @SqlStr +=	' 0 AS Cantidad,'
		SET @SqlStr +=	' '''' AS Lote,'
		SET @SqlStr +=	' PR.Id_Sector,'
		SET @SqlStr +=	' S.Codigo AS Sector_Codigo,'
		SET @SqlStr +=	' S.Descripcion AS Sector_Nombre,'
		SET @SqlStr +=	' PR.Columna,'
		SET @SqlStr +=	' PR.Fila,'
		SET @SqlStr +=	' '''' AS Fecha_Evento'
		SET @SqlStr +=	' FROM Tab_Ent_Protocolares_Items I, Tab_Ent_Protocolares E, Productos PR, Empresas_Sedes_Sectores S'
		SET @SqlStr +=	' WHERE'
		SET @SqlStr +=	' I.Id_Ent_Protocolo = E.Id_Ent_Protocolo'
		SET @SqlStr +=	' AND I.Id_Producto = PR.Id_Producto'
		SET @SqlStr +=	' AND PR.Id_Sector = S.Id_Sector'
		SET @SqlStr +=	' AND I.Activo = 1'
		SET @SqlStr +=	' AND E.Activo = 1'

		IF(@pId_Sector <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
		END

		IF(@pId_Producto <> '')
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Producto = ''' + @pId_Producto +''''
		END


		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@SqlStr: ' + @SqlStr
		END

		EXECUTE sp_executesql @SqlStr

		IF(@pModoDebug = 1)
		BEGIN
			PRINT ''
		END
	END
END
	/*=======================================================================EN PROCESO DE VENTA=============================================================================*/
IF @pInc_ProcesoVta = 1
BEGIN
	IF(@pId_Cliente = 0)
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'EN PROCESO DE VENTA'
		END

		SET @cant_min_reserva = CONVERT(INT, dbo.CF_xParam('cant_min_reserva'))

		SET @SqlStr =	''

		SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Localidades_Ocupadas '
		SET @SqlStr +=	' SELECT'
		SET @SqlStr +=	' 0 AS Id_Trans,'
		SET @SqlStr +=	' 0 AS Id_Cliente,'
		SET @SqlStr +=	' 0 AS Id_Lista,'
		SET @SqlStr +=	' '''' AS Razon_Social,'
		SET @SqlStr +=	' '''' AS Fecha_QA,'
		SET @SqlStr +=	' '''' AS Fecha_Venc,'
		SET @SqlStr +=	' '''' AS Fecha_Desde,'
		SET @SqlStr +=	' '''' AS Fecha_Hasta,'
		SET @SqlStr +=	' '''' AS Descripcion,'
		SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(PR.Id_Producto, '''')))) AS Id_Producto,'
		SET @SqlStr +=	' UPPER(RTRIM(LTRIM(ISNULL(PR.Descripcion_Resumida, '''')))) AS Descripcion_Resumida,'
		SET @SqlStr +=	'''PV'' AS Estado,'
					/*
						A	-> Abono Comprado     
						ARA -> Abono Reserva Anticipada    
						AR	-> Abono Resevado     
						TV	-> Ticket Vendido
						TC	-> Ticket Canjeado
						TI	-> Ticket Impreso
						PI	-> Protocolos Impresos
						PU	-> Protocolo Fijo
						PV	-> En Proceso de Venta
					*/
		SET @SqlStr +=	' '''' AS Serie,'
		SET @SqlStr +=	' 0 AS Item,'
		SET @SqlStr +=	' '''' AS Flag_QA,'
		SET @SqlStr +=	' '''' AS Fecha_Cbte,'
		SET @SqlStr +=	' '''' AS Cbte_Descrip,'
		SET @SqlStr +=	' 0 AS Id_Estado_Cbte,'
		SET @SqlStr +=	' 0 AS Cantidad,'
		SET @SqlStr +=	' '''' AS Lote,'
		SET @SqlStr +=	' PR.Id_Sector,'
		SET @SqlStr +=	' S.Codigo AS Sector_Codigo,'
		SET @SqlStr +=	' S.Descripcion AS Sector_Nombre,'
		SET @SqlStr +=	' PR.Columna,'
		SET @SqlStr +=	' PR.Fila,'
		SET @SqlStr +=	' '''' AS Fecha_Evento'
		SET @SqlStr +=	' FROM Productos PR, Empresas_Sedes_Sectores S'
		SET @SqlStr +=	' WHERE'
		SET @SqlStr +=	' PR.Fecha_Reserva >= DATEADD(MINUTE, (-1) * ' + CONVERT(VARCHAR(10), @cant_min_reserva) +', GETDATE())'
		SET @SqlStr +=	' AND PR.Id_Sector = S.Id_Sector'


		IF(@pId_Producto <> '')
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Producto = ''' + @pId_Producto +''''
		END

		IF(@pId_Sector <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
		END

		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@SqlStr: ' + @SqlStr
		END

		EXECUTE sp_executesql @SqlStr

		IF(@pModoDebug = 1)
		BEGIN
			PRINT ''
		END
	END
END
	/*====================================================================================================================================================*/

	IF @pInc_Libres = 1 
	BEGIN
	    SELECT Id_Sector,Codigo,Descripcion INTO #Sectores FROM Empresas_Sedes_Sectores

		IF(@pId_Sector <> 0)
		BEGIN
			DELETE #Sectores WHERE Id_Sector <>  @pId_Sector
		END

		INSERT INTO #Rta_CPJ_Localidades_Ocupadas 
			SELECT 
					 0 AS Id_Trans,
					 0 AS Id_Cliente,
					 @pId_Lista_Precio AS Id_Lista,
					 '' AS Razon_Social,
					 '' AS Fecha_QA,
					 '' AS Fecha_Venc,
					 '' AS Fecha_Desde,
					 '' AS Fecha_Hasta,
					 '' AS Descripcion,
					 P.Id_Producto ,
					 P.Descripcion_Resumida,
					 'L' AS Estado,
					 '' AS Serie,
					 0 AS Item,
					 '' AS Flag_QA,
					 '' AS Fecha_Cbte,
					 '' AS Cbte_Descrip,
					 0 AS Id_Estado_Cbte,
					 0 AS Cantidad,
					 '' AS Lote,
					 P.Id_Sector,
					 S.Codigo AS Sector_Codigo,
					 S.Descripcion AS Sector_Nombre,
					 P.Columna,
					 P.Fila,
					 '' AS Fecha_Evento
			FROM Productos P , Prod_Listas_Precios_Items I , #Sectores S
            WHERE P.Activo = 1 		 
					AND I.Id_Producto = P.Id_Producto
					AND I.Id_Lista_Precio = @pId_Lista_Precio
					AND P.Id_Sector = S.Id_Sector 
					AND NOT EXISTS (SELECT 1 FROM #Rta_CPJ_Localidades_Ocupadas R WHERE R.Id_Producto COLLATE Modern_Spanish_CI_AS = P.Id_Producto COLLATE Modern_Spanish_CI_AS)

        IF UPPER(@pFormato) = 'TS'
		BEGIN
			SELECT Sector_Codigo,Id_Sector,Sector_Nombre,COUNT(*) AS Total, 0 AS Ocupadas, 0 AS Libres 
				INTO #Tot_Sector FROM #Rta_CPJ_Localidades_Ocupadas GROUP BY Sector_Codigo,Id_Sector,Sector_Nombre

			SELECT Sector_Codigo,Id_Sector,Sector_Nombre,COUNT(*) AS Libres 
				INTO #Tot_Sector_L FROM #Rta_CPJ_Localidades_Ocupadas WHERE Estado = 'L' GROUP BY Sector_Codigo,Id_Sector,Sector_Nombre

			SELECT Sector_Codigo,Id_Sector,Sector_Nombre,COUNT(*) AS Ocupadas
				INTO #Tot_Sector_O FROM #Rta_CPJ_Localidades_Ocupadas WHERE Estado <> 'L' GROUP BY Sector_Codigo,Id_Sector,Sector_Nombre

		    UPDATE #Tot_Sector SET Libres = L.Libres	FROM #Tot_Sector T,  #Tot_Sector_L L WHERE T.Id_Sector = L.Id_Sector
		    UPDATE #Tot_Sector SET Ocupadas = O.Ocupadas	FROM #Tot_Sector T,  #Tot_Sector_O O WHERE T.Id_Sector = O.Id_Sector

			SELECT * FROM #Tot_Sector

        END
        ELSE IF UPPER(@pFormato) = 'TT'
		BEGIN
			SELECT Estado,COUNT(*) AS Total FROM #Rta_CPJ_Localidades_Ocupadas  GROUP BY Estado
		END
		ELSE
			SELECT * FROM #Rta_CPJ_Localidades_Ocupadas ORDER BY Sector_Codigo,Id_Sector,CONVERT(INT,Columna),CONVERT(INT,Fila)



	END
	ELSE  --IF @pInc_Libres = 1 
	   SELECT * FROM #Rta_CPJ_Localidades_Ocupadas ORDER BY Sector_Codigo,Id_Sector,Columna,Fila
    

	/*====================================================================================================================================================*/

	IF OBJECT_ID('tempdb..#Rta_CPJ_Localidades_Ocupadas') IS NOT NULL
	BEGIN
		DROP TABLE #Rta_CPJ_Localidades_Ocupadas
	END

	IF OBJECT_ID('tempdb..#Tot_Sector') IS NOT NULL
	BEGIN
		DROP TABLE #Tot_Sector
	END

	IF OBJECT_ID('tempdb..#Tot_Sector_L') IS NOT NULL
	BEGIN
		DROP TABLE #Tot_Sector_L
	END

	IF OBJECT_ID('tempdb..#Tot_Sector_O') IS NOT NULL
	BEGIN
		DROP TABLE #Tot_Sector_O
	END


	/*====================================================================================================================================================*/

	IF @pFlagUsarTrans <> 0 COMMIT
	
	/*====================================================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: [CPJ_Localidades_Ocupadas]'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 


/*


EXEC [CPJ_Localidades_Ocupadas] '{"ModoDebug":"1","Id_Cliente":"0","Id_Lista_Precio":"2002","Id_Sector":"28","Inc_Libres":"1","Formato":"TS"}'

EXEC [CPJ_Localidades_Ocupadas] '{"ModoDebug":"1","Id_Cliente":"0","Id_Lista_Precio":"2002","Inc_Libres":"1","Formato":"TS"}'

EXEC [CPJ_Localidades_Ocupadas] '{"ModoDebug":"1","Id_Cliente":"0","Id_Lista_Precio":"2002","Inc_Libres":"1","Formato":"TT"}'

EXEC [CPJ_Localidades_Ocupadas] '{"FlagUsarTrans":"0", "ModoDebug":"0", "Id_Sector":"", "Id_Cliente":"0", "Id_Lista_Precio":"1024", "Flag_Interface":"G" }'


*/

